/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.data.Deal;

public class MarcetSection {
    private final int id;
    public String name = "market.default.section";
    public List<Deal> deals = new ArrayList<Deal>();

    public static MarcetSection create(NBTTagCompound compound) {
        MarcetSection ms = new MarcetSection(compound.func_74762_e("ID"));
        ms.name = compound.func_74779_i("Name");
        NBTTagList list = compound.func_150295_c("Deals", 10);
        for (NBTBase nbt : list) {
            Deal deal = new Deal();
            deal.readDataNBT((NBTTagCompound)nbt);
            ms.deals.add(deal);
        }
        return ms;
    }

    public MarcetSection(int id) {
        this.id = id;
    }

    public void addDeal(int dealId) {
        if (this.hadDeal(dealId)) {
            return;
        }
        Deal deal = (Deal)MarcetController.getInstance().getDeal(dealId);
        if (deal == null || !deal.isValid()) {
            return;
        }
        Deal marcetDeal = deal.copy();
        marcetDeal.updateNew();
        this.deals.add(marcetDeal);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return new TextComponentTranslation(this.name, new Object[0]).func_150254_d();
    }

    private boolean hadDeal(int dealId) {
        for (Deal deal : this.deals) {
            if (deal.getId() != dealId) continue;
            return true;
        }
        return false;
    }

    public void removeAllDeals() {
        this.deals.clear();
    }

    public void removeDeal(int dealId) {
        for (Deal deal : this.deals) {
            if (deal.getId() != dealId) continue;
            this.deals.remove(deal);
            return;
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        compound.func_74778_a("Name", this.name);
        NBTTagList list = new NBTTagList();
        for (Deal deal : this.deals) {
            list.func_74742_a((NBTBase)deal.writeDataToNBT());
        }
        compound.func_74782_a("Deals", (NBTBase)list);
        return compound;
    }
}

